// -*- Java -*-
/*!
 * @file  RSNP_HMDImpl.java
 * @brief Connect_RSNPServer
 * @date  $Date$
 *
 * @author Author: Hiroshi Ogiya
 * Contact Information: Shibaura Insutitute of
 * Technology. 3-7-5 Toyosu Koto-ku Tokyo 135-8548
 * Email:md14017@shibaura-it.ac.jp
 *
 * Apply the correction BSD license.
 *
 * $Id$
 */

import rsnp.RSNPAccess;
import rtm.RTMRecivedData;
import RTC.PanTiltAngles;
import jp.go.aist.rtm.RTC.DataFlowComponentBase;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.port.InPort;
import jp.go.aist.rtm.RTC.util.DataRef;
import RTC.ReturnCode_t;

/*!
 * @class RSNP_HMDImpl
 * @brief Connect_RSNPServer
 *
 * Receive  the attitude data(Pan, Tilt) of the HMD from another
 * component and send them to the RSNP Server using
 * distribute_senser_info method (Multimedia_Profile class).
 *
 * Input: PanTiltAngles
 * Output: Nothing
 *
 * Robot Service Network Protocol2.2 Specification
 *
 */
public class RSNP_HMDImpl extends DataFlowComponentBase {

  /*!
   * @brief constructor
   * @param manager Maneger Object
   */
	public RSNP_HMDImpl(Manager manager) {  
        super(manager);
        // <rtc-template block="initializer">
        m_HMDData_val = new PanTiltAngles();
        m_HMDData = new DataRef<PanTiltAngles>(m_HMDData_val);
        m_HMDDataIn = new InPort<PanTiltAngles>("HMDData", m_HMDData);
        // </rtc-template>

    }

    /**
     *
     * The initialize action (on CREATED->ALIVE transition)
     * formaer rtc_init_entry() 
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
    @Override
    protected ReturnCode_t onInitialize() {
        // Registration: InPort/OutPort/Service
        // <rtc-template block="registration">
        // Set InPort buffers
        addInPort("HMDData", m_HMDDataIn);
        // </rtc-template>
        RTMRecivedData.getInstance().set_HMDData(0,0);
        
        return super.onInitialize();
    }

    /***
     *
     * The finalize action (on ALIVE->END transition)
     * formaer rtc_exiting_entry()
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onFinalize() {
//        return super.onFinalize();
//    }

    /***
     *
     * The startup action when ExecutionContext startup
     * former rtc_starting_entry()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onStartup(int ec_id) {
//        return super.onStartup(ec_id);
//    }

    /***
     *
     * The shutdown action when ExecutionContext stop
     * former rtc_stopping_entry()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onShutdown(int ec_id) {
//        return super.onShutdown(ec_id);
//    }

    /***
     *
     * The activated action (Active state entry action)
     * former rtc_active_entry()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
    @Override
    protected ReturnCode_t onActivated(int ec_id) {
    	RSNPAccess rsnp = RSNPAccess.getInstance();
    	rsnp.open();
    	
        return super.onActivated(ec_id);
    }

    /***
     *
     * The deactivated action (Active state exit action)
     * former rtc_active_exit()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
    @Override
    protected ReturnCode_t onDeactivated(int ec_id) {
    	RSNPAccess rsnp = RSNPAccess.getInstance();
    	rsnp.close();
    	
        return super.onDeactivated(ec_id);
    }

    /***
     *
     * The execution action that is invoked periodically
     * former rtc_active_do()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
    @Override
    protected ReturnCode_t onExecute(int ec_id) {
    	if(m_HMDDataIn.isNew()){
    		m_HMDDataIn.read();
    		RTMRecivedData rtm_recive =RTMRecivedData.getInstance();
    		rtm_recive.set_HMDData((int)m_HMDData.v.pan,(int)m_HMDData.v.tilt);
    	}
    	
        return super.onExecute(ec_id);
    }

    /***
     *
     * The aborting action when main logic error occurred.
     * former rtc_aborting_entry()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//  @Override
//  public ReturnCode_t onAborting(int ec_id) {
//      return super.onAborting(ec_id);
//  }

    /***
     *
     * The error action in ERROR state
     * former rtc_error_do()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
    @Override
    public ReturnCode_t onError(int ec_id) {
        return super.onError(ec_id);
    }

    /***
     *
     * The reset action that is invoked resetting
     * This is same but different the former rtc_init_entry()
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
    @Override
    protected ReturnCode_t onReset(int ec_id) {
        return super.onReset(ec_id);
    }

    /***
     *
     * The state update action that is invoked after onExecute() action
     * no corresponding operation exists in OpenRTm-aist-0.2.0
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onStateUpdate(int ec_id) {
//        return super.onStateUpdate(ec_id);
//    }

    /***
     *
     * The action that is invoked when execution context's rate is changed
     * no corresponding operation exists in OpenRTm-aist-0.2.0
     *
     * @param ec_id target ExecutionContext Id
     *
     * @return RTC::ReturnCode_t
     * 
     * 
     */
//    @Override
//    protected ReturnCode_t onRateChanged(int ec_id) {
//        return super.onRateChanged(ec_id);
//    }
//
    // DataInPort declaration
    // <rtc-template block="inport_declare">
    protected PanTiltAngles m_HMDData_val;
    protected DataRef<PanTiltAngles> m_HMDData;
    /*!
     * Get the attitude data(Pan, Tilt) of the HMD.
     * First data is Pan angle, second data is Tilt angle.
     * - Type: PanTiltAngles
     * - Number: 2
     * - Unit: degree
     * - Frequency: 1000.0
     * - Operation Cycle: 1000.0
     */
    protected InPort<PanTiltAngles> m_HMDDataIn;

    
    // </rtc-template>

    // DataOutPort declaration
    // <rtc-template block="outport_declare">
    
    // </rtc-template>

    // CORBA Port declaration
    // <rtc-template block="corbaport_declare">
    
    // </rtc-template>

    // Service declaration
    // <rtc-template block="service_declare">
    
    // </rtc-template>

    // Consumer declaration
    // <rtc-template block="consumer_declare">
    
    // </rtc-template>


}
