// -*- Java -*-
/*!
 * @file RSNP_HMD.java
 * @date $Date$
 *
 * @author Author: Hiroshi Ogiya
 * Contact Information: Shibaura Insutitute of
 * Technology. 3-7-5 Toyosu Koto-ku Tokyo 135-8548
 * Email:md14017@shibaura-it.ac.jp
 *
 * Apply the correction BSD license.
 *
 * $Id$
 */

import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.RTObject_impl;
import jp.go.aist.rtm.RTC.RtcDeleteFunc;
import jp.go.aist.rtm.RTC.RtcNewFunc;
import jp.go.aist.rtm.RTC.RegisterModuleFunc;
import jp.go.aist.rtm.RTC.util.Properties;

/*!
 * @class RSNP_HMD
 * @brief Connect_RSNPServer
 */
public class RSNP_HMD implements RtcNewFunc, RtcDeleteFunc, RegisterModuleFunc {

//  Module specification
//  <rtc-template block="module_spec">
    public static String component_conf[] = {
    	    "implementation_id", "RSNP_HMD",
    	    "type_name",         "RSNP_HMD",
    	    "description",       "Connect_RSNPServer",
    	    "version",           "1.0.0",
    	    "vendor",            "Hiroshi_Ogiya",
    	    "category",          "Communicatio",
    	    "activity_type",     "STATIC",
    	    "max_instance",      "1",
    	    "language",          "Java",
    	    "lang_type",         "compile",
    	    ""
            };
//  </rtc-template>

    public RTObject_impl createRtc(Manager mgr) {
        return new RSNP_HMDImpl(mgr);
    }

    public void deleteRtc(RTObject_impl rtcBase) {
        rtcBase = null;
    }
    public void registerModule() {
        Properties prop = new Properties(component_conf);
        final Manager manager = Manager.instance();
        manager.registerFactory(prop, new RSNP_HMD(), new RSNP_HMD());
    }
}
