// -*- C++ -*-
/*!
 * @file  averaging.cpp
 * @brief average
 * @date $Date$
 *
 * @author Author: Hiroshi Ogiya
 * Contact Information: Shibaura Insutitute of
 * Technology. 3-7-5 Toyosu Koto-ku Tokyo 135-8548
 * Email:md14017@shibaura-it.ac.jp
 *
 * Apply the correction BSD license.
 *
 * $Id$
 */

#include "averaging.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

using namespace std;
void Arraylist_analysis(double angles[], int n, double new_angles, int k);

struct new_data
{
		double count;
		double pan_angles;
		double tilt_angles;
};
new_data new_angles;

struct angles_data
{
		double pan_angles[20];
		double tilt_angles[20];
};

void Arraylist_analysis(double data[], int n, double newdata, int k)	//f[^11oĂ
{
	int i;
	for(i=n; i>k; i--)
	{
		data[i] = data[i-1];
	}
	data[k] = newdata;
}
angles_data angles;
// Module specification
// <rtc-template block="module_spec">
static const char* averaging_spec[] =
  {
    "implementation_id", "averaging",
    "type_name",         "averaging",
    "description",       "average",
    "version",           "1.0.0",
    "vendor",            "Hiroshi Ogiya",
    "category",          "analysi",
    "activity_type",     "PERIODIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    "conf.default.n", "10",
    // Widget
    "conf.__widget__.n", "text",
    // Constraints
    "conf.__constraints__.n", "Only positive integer",
    ""
  };
// </rtc-template>

/*!
 * @brief constructor
 * @param manager Maneger Object
 */
averaging::averaging(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_potision_InIn("potision_In", m_potision_In),
    m_position_OutOut("position_Out", m_position_Out)

    // </rtc-template>
{
}

/*!
 * @brief destructor
 */
averaging::~averaging()
{
}



RTC::ReturnCode_t averaging::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("potision_In", m_potision_InIn);
  
  // Set OutPort buffer
  addOutPort("position_Out", m_position_OutOut);
  
  // Set service provider to Ports
  
  // Set service consumers to Ports
  
  // Set CORBA Service Ports
  
  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable
  bindParameter("n", m_n, "10");
  // </rtc-template>
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t averaging::onFinalize()
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t averaging::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t averaging::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


RTC::ReturnCode_t averaging::onActivated(RTC::UniqueId ec_id)
{
	m_potision_In.tm.sec = 0;
	m_potision_In.pan = 0;
	m_potision_In.tilt = 0;

	m_position_Out.tm.sec = 0;
	m_position_Out.pan = 0;
	m_position_Out.tilt = 0;
  
	return RTC::RTC_OK;
}


RTC::ReturnCode_t averaging::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}


RTC::ReturnCode_t averaging::onExecute(RTC::UniqueId ec_id)
{
	int i = 0;
	double SUM_pan, SUM_tilt;
	SUM_pan = 0;
	SUM_tilt = 0;
	double AVE_pan, AVE_tilt;
	AVE_pan = 0;
	AVE_tilt = 0;

	if(m_potision_InIn.isNew())
	{
			m_potision_InIn.read();
			
			new_angles.count = i;
			new_angles.pan_angles = m_potision_In.pan;
			new_angles.tilt_angles = m_potision_In.tilt;

			Arraylist_analysis(angles.pan_angles, m_n, m_potision_In.pan, 1);
			Arraylist_analysis(angles.tilt_angles, m_n, m_potision_In.tilt, 1);

			i++;
			for(int x=1; x<m_n+1; x++){
				SUM_pan += angles.pan_angles[x];
				SUM_tilt += angles.tilt_angles[x];
				if(x==m_n)
				{
					AVE_pan = SUM_pan/m_n;
					AVE_tilt = SUM_tilt/m_n;
					cout<<"pan_In="<<AVE_pan<<"; tilt_In="<<AVE_tilt<<endl;
					Sleep(50);
				}

			}
			
			m_position_Out.pan = AVE_pan;
			m_position_Out.tilt = AVE_tilt;
			m_position_OutOut.write();
		
	}

	return RTC::RTC_OK;
}


RTC::ReturnCode_t averaging::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}


RTC::ReturnCode_t averaging::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}


RTC::ReturnCode_t averaging::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t averaging::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t averaging::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/



extern "C"
{
 
  void averagingInit(RTC::Manager* manager)
  {
    coil::Properties profile(averaging_spec);
    manager->registerFactory(profile,
                             RTC::Create<averaging>,
                             RTC::Delete<averaging>);
  }
  
};


