//------------------------------------------------------------
//  HMD Program
//@XN[WnŃ}[J[̕ψʊpx擾
//  ύX 2014 Oct 31th
//------------------------------------------------------------
#include "AR_data_out.h"

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <GL\gl.h>
#include <GL\glu.h>
#include <GL\glut.h>
#include "Gsub.h"
#include "video.h"
#include "param.h"
#include "ar.h"

/*ǉwb_t@C*/
#include <math.h>
#include <io.h>
#include <iostream>
#include <fcntl.h>

using namespace std;

//------------------------------------------------------------

/* J\ */
char	*vconf = "C:\\ARToolKit\\bin\\Data\\WDM_camera_flipV.xml";		// ̃J\
int		xsize;															// EBhETCY
int		ysize;															// EBhETCY
int		thresh   = 100;													// 臒l(0`255)
int		count_ar = 0;													// t[
int     my_count = 0;
double  sum_anglex = 0,
		sum_anglex2 = 0;
double  sum_anglexg  = 0,
		sum_anglexg2 = 0;
/* Jp[^ */
char		*cparam_name = "C:\\ARToolKit\\bin\\Data\\BUFFALO_USB_CAMERA_para.dat";	//pX̎w𐳊mɂ
ARParam		cparam;																	// Jp[^

/* p^[t@C */
#define	OBJ_NUM			2										// gp}[J[̌
//-----
#define	OBJ1_MARK_ID	1										// }[J[ID
#define	OBJ1_PATT_NAME	"C:\\ARToolKit\\bin\\Data\\patt.A"		// p^[t@C
#define	OBJ1_SIZE		50										// p^[̕i110mmj
//-----
#define	OBJ2_MARK_ID	2										// }[J[ID
#define	OBJ2_PATT_NAME	"C:\\ARToolKit\\bin\\Data\\patt.B"		// p^[t@C
#define	OBJ2_SIZE		50										// p^[̕i110mmj
//-----

/*OBJECT_T\̂ɂp^[t@C̈ꊇǗ*/
typedef struct {
  char		*patt_name;		// p^[t@C
  int		patt_id;		// p^[ID
  int		mark_id;		// }[J[ID
  int		visible;		// otO
  double	width;			// p^[̕immPʁj
  double	center[2];		// p^[̒SW
  double	trans[3][4];	// Wϊs
} OBJECT_T;
//-----

OBJECT_T	object[OBJ_NUM] = {
		{OBJ1_PATT_NAME, -1, OBJ1_MARK_ID, 0, OBJ1_SIZE, {0.0,0.0}},
		{OBJ2_PATT_NAME, -1, OBJ2_MARK_ID, 0, OBJ2_SIZE, {0.0,0.0}}
	};

/* IuWFNg̉]px */
//GLfloat		exRz = 0;		// z܂̉]px(Namatame)
//------------------------------------------------------------

//e֐`
static void init(void);	
static void mainloop(void);
void draw(int mid, double patt_trans[3][4]);
static void setupLighting(void);
static void setupMaterial(void);
static void cleanup(void);
static void keyEvent(unsigned char key, int x, int y);
double AR_PI = 3.1415926535897932384;					//~`

char    *file_dir;
LPVOID  GParam;
ARParam	wparam;				// Jp[^
bool    stop_flag=false;
int     sc_count=0;
AR_data_out* GpDlg;

bool AR_finder(LPVOID pParam)
{
	AR_data_out* pDlg = (AR_data_out*)pParam;
	GpDlg=pDlg;
	int argc=1;
	char* argv[]={"NULL"};
	
//------------------------------------------------------------
//@C֐
//  
//------------------------------------------------------------

	/* GLUT̏ */
	glutInit(&argc, argv);
	
	/* rfIfoCX̐ݒ */
	if( arVideoOpen( vconf ) < 0 ) exit(0);

	/* EBhETCY̎擾 */
	if( arVideoInqSize(&xsize, &ysize) < 0 ) exit(0);
	std::cout << "Image size (x,y) = (" << xsize<<"," << ysize << ")\n" << std::endl;
	
	/* Jp[^̓ǂݍ */
	if( arParamLoad(cparam_name, 1, &wparam) < 0 ) {
		std::cout << "Camera parameter load error !!\n" << std::endl;
		return 1;
	}
	
	/* Jp[^̏ */
	arParamChangeSize( &wparam, xsize, ysize, &cparam );
	arInitCparam( &cparam );
	std::cout << "*** Camera Parameter ***\n" << std::endl;
	arParamDisp( &cparam );


	for (int i = 0; i < OBJ_NUM; i++){
		if( (object[i].patt_id = arLoadPatt(object[i].patt_name)) < 0 ) {
			return 1;
		}
	}
	
	/* gsubCȕ */
	argInit( &cparam, 1.0, 0, 0, 0, 0 );

	/* Lv`Jn */
	arVideoCapStart();
	
	/* C[v̌Ăяo */
	argMainLoop( NULL, keyEvent, mainloop );
	
	return 0;
}

//------------------------------------------------------------
//@C[v
//------------------------------------------------------------
static void mainloop(void)
{
	ARUint8			*dataPtr;					// J摜
	ARMarkerInfo	*marker_info;				// }[J[op̏
	int				marker_num;					// }[J[炵̌
	double			wmat[3][4], wmat1[3][4];	// ϊs

	//}[JA
	double sum_xg=0,		
		   sum_yg=0,
		   sum_zg=0;
	//}[JB
	double sum_x1=0,		
		   sum_y1=0,
		   sum_z1=0;
	double sum_t=0;
	//}[JԂ̋
	int l = 30;
	//Βlpϐ
	double c1 = 0,
		   d1 = 0,
		   c2 = 0,
		   d2 = 0;
	//؂̂ėpϐ
	int e = 0,
		f = 0;
	double rot1 = 0,		//ՃJpx
		   rot2 = 0;		//ՃJcpx
	double average_x1=0,	//}[JBψʒu
		   average_y1=0,
		   average_z1=0;
	double average_xg=0,	//}[JAψʒu
		   average_yg=0,
		   average_zg=0;
	double zg = 0;
	double z = 0;
	double average_t=0;

	FILE   *file;

	/* J摜̎擾 */
	if( (dataPtr = (ARUint8 *)arVideoGetImage()) == NULL ){
		arUtilSleep(2);
		return;
	}
		
	if( count_ar == 0 ) arUtilTimerReset();
	count_ar++;

	/* Lv`摜̕\ */
	argDrawMode2D();
	argDispImage( dataPtr, 0, 0 );

	/* }[J[̌o */
	if( arDetectMarker(dataPtr, thresh, &marker_info, &marker_num) < 0 ) {
		cleanup();
		exit(0);
	}

	/* ̉摜Lv` */
	arVideoCapNext();

	/* 3IuWFNg̕`揀 */
	argDrawMode3D();
	argDraw3dCamera(0, 0);

	/* fvXEobt@̏ */
	glClearDepth(1.0);				// fvXEobt@̏l
	glClear(GL_DEPTH_BUFFER_BIT);	// fvXEobt@̏

	/* }[J[̈vx𔻒 */
	for (int i = 0; i < OBJ_NUM; i++){
		int k = -1;
		for(int j = 0; j < marker_num; j++ ){
			if( object[i].patt_id == marker_info[j].id ){
				if( k == -1 ) k = j;
				else if( marker_info[k].cf < marker_info[j].cf ) k = j;
			}
		}

		/* }[J[ȂƂ */
		if( k == -1 ){
			object[i].visible = 0;
			continue;
		}

		/* Wϊs擾 */
		if( object[i].visible == 0 ){
			// Pt[gčWϊs擾
			arGetTransMat(&marker_info[k],
							object[i].center, 
							object[i].width, 
							object[i].trans);
  		}else{
			// Õt[gčWϊs擾
			arGetTransMatCont(&marker_info[k], 
								object[i].trans,
								object[i].center, 
								object[i].width, 
								object[i].trans);
  		}
		object[i].visible = 1;

		/* 3IuWFNg̕`揈 */
		draw(object[i].mark_id,object[i].trans);
	}

	/* obt@̓eo */
	argSwapBuffers();

	/* }[J[Ƃ */
	if (object[0].visible > 0 || object[1].visible> 0 ){
		//ǂ̃}[J[Ă邩
		int mflag=0;

		for(int flag_num=0;flag_num<OBJ_NUM;flag_num++){
			if(object[flag_num].visible	==	1){
				mflag=flag_num;
				if(flag_num==0)
				{
				memcpy(wmat, object[flag_num].trans, sizeof(object[flag_num].trans));	//}[J[0̍WnŃJ̈ʒu擾
				}
				if(flag_num==1)
				{
				memcpy(wmat1, object[flag_num].trans, sizeof(object[flag_num].trans));	//}[J[0̍WnŃJ̈ʒu擾
				}
			}
		}
//------------------------------------------------------------
//  mainloop̕ύX
//@ϊs񂩂e}[J̊pxZo,
//	o̓|[gf[^o͂܂.
//------------------------------------------------------------
		//e}[J̊pxZo
		double  anglex  = 0,
				angley  = 0,
				anglez  = 0;
		double  anglex2 = 0,
				angley2 = 0,
				anglez2 = 0;
		double  ave_anglex = 0,
				ave_anglex2= 0;
		double  anglexg  = 0,
				angleyg  = 0,
				anglezg  = 0;
		double  anglexg2 = 0,
				anglezg2 = 0;
		double  ave_anglexg  = 0,
				ave_anglexg2 = 0;
		double  ave_angle_y,
				ave_angle_p  = 0;
		/*--------------------}[J1̊px--------------------------------*/
		angley  =- asin(wmat[2][0]);

		anglez  =  acos(wmat[0][0] / cos(angley));
		anglez2 =  asin(wmat[1][0] / cos(angley));
		if(anglez <= AR_PI/2){
			if(anglez2 > 0)anglez = (anglez + anglez2)/2;
			else if(anglez2 < 0)anglez = (-anglez + anglez2)/2;
			else anglez = 0;
		}else{
			if(anglez2 > 0)anglez = (anglez + (AR_PI - anglez2))/2;
			else if(anglez2 < 0)anglez = (-anglez + (-AR_PI - anglez2))/2;
			else anglez = AR_PI;
		}

		anglex  = -3.14159+acos(wmat[2][2] / cos(angley));
		anglex2 = asin(wmat[2][1] / cos(angley));
		if(anglex2 >=0 ){
				anglex2 = (anglex2 - anglex)/2;
		}else{
				anglex2 = (anglex2 + anglex)/2;
		}
		
		/*--------------------}[J2̊px--------------------------------*/
		
		angleyg  = asin(wmat1[2][0]);
		anglezg  = acos(wmat1[0][0] / cos(angleyg));
		anglezg2 = asin(wmat1[1][0] / cos(angleyg));

		if(anglez <= AR_PI/2){
			if(anglezg2 > 0)anglezg = (anglezg + anglezg2)/2;
			else if(anglezg2 < 0)anglezg = (-anglezg + anglezg2)/2;
			else anglezg = 0;
		}else{
			if(anglezg2 > 0)anglezg = (anglezg + (AR_PI - anglezg2))/2;
			else if(anglezg2 < 0)anglezg = (-anglezg + (-AR_PI - anglezg2))/2;
			else anglezg = AR_PI;
		}

		anglexg  = -3.14159+acos(wmat1[2][2] / cos(angleyg));
		anglexg2 = asin(wmat1[2][1] / cos(angleyg));
		if(anglexg2 >=0 ){
				anglexg2 = (anglexg2 - anglexg)/2;
		}else{
				anglexg2 = (anglexg2 + anglexg)/2;
		}
		
		/*--------------------2̃}[J̕--------------------*/
		ave_angle_y = (anglex2 + anglexg2)/2/2/3.14159*360;
		ave_angle_p = (anglez + anglezg2)/2/2/3.14159*360;

		sum_x1 = 0,
		sum_z1 = 0;
			
		/*--------------------px̏o--------------------*/
		//x̉]
		if( -60 < ave_angle_y && ave_angle_y < 60 ){
			GpDlg -> m_positionOut.pan= -ave_angle_y;
		}
			
		//z̉]
		if( -60 < ave_angle_p && ave_angle_p < 60 ){
			GpDlg -> m_positionOut.tilt = ave_angle_p;
		}
		std::cout << "real_ave_angle_y = "<< (int)ave_angle_y <<" , "<< "real_ave_angle_p = "<< (int)ave_angle_p<< std::endl;
		GpDlg -> m_positionOutOut.write();
		Sleep(20);

		ave_angle_y = 0;
		ave_angle_p = 0;
	}
}

//------------------------------------------------------------
//@3IuWFNg̕`揈
//------------------------------------------------------------
void draw(int mid,double patt_trans[3][4])
{
	double	gl_para[16];					// ARToolkitϊOpenGL̍s
    
	/* 3IuWFNg̕`揀 */
	argDrawMode3D();
	argDraw3dCamera(0, 0);
    
	/* Bʏ */
	glClearDepth(1.0);						// fvXEobt@̏l
	glClear(GL_DEPTH_BUFFER_BIT);			// fvXEobt@̏
	glEnable(GL_DEPTH_TEST);				// BʏEL
	glDepthFunc(GL_LEQUAL);					// fvXEeXg
    
	/* Wϊs̓ǂݍ */
	argConvGlpara(patt_trans, gl_para);		// ARToolkit -> OpenGL
	glMatrixMode(GL_MODELVIEW);				// sϊ[hEfr[
	glLoadMatrixd(gl_para);					// ǂݍލsw

	/* CeBO */
	setupLighting();						// Cg̒`
	glEnable(GL_LIGHTING);					// CeBOEL
	glEnable(GL_LIGHT0);					// Cg0EI
	glEnable(GL_LIGHT1);					// Cg1EI

	/* IuWFNg̍ގ */
	setupMaterial();

	/* 3IuWFNg̕` */
	glTranslatef(0.0, 0.0, 25.0);			// IuWFNg̕sړiz25mmړj
	glutSolidCube(50.0);					// \bhL[u`iPӂ̃TCY50mmj
		
	/* I */
	glDisable(GL_LIGHTING);					// CeBOE
	glDisable(GL_DEPTH_TEST);				// fvXEeXgE
}
//------------------------------------------------------------
//@CeBO
//------------------------------------------------------------
static void setupLighting(void)
{
	/* Cg̒` */
	GLfloat	lt0_position[] = {100.0, -200.0, 200.0, 0.0};	// Cg0̈ʒu
	GLfloat	lt0_ambient[]  = {0.1, 0.1, 0.1, 1.0};			//          
	GLfloat	lt0_diffuse[]  = {0.8, 0.8, 0.8, 1.0};			//          gU
	//
	GLfloat	lt1_position[] = {-100.0, 200.0, 200.0, 0.0};	// Cg1̈ʒu
	GLfloat	lt1_ambient[]  = {0.1, 0.1, 0.1, 1.0};			//          
	GLfloat	lt1_diffuse[]  = {0.8, 0.8, 0.8, 1.0};			//          gU

	/* Cg̐ݒ */
	glLightfv(GL_LIGHT0, GL_POSITION, lt0_position);
	glLightfv(GL_LIGHT0, GL_AMBIENT, lt0_ambient);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, lt0_diffuse);
	//
	glLightfv(GL_LIGHT1, GL_POSITION, lt1_position);
	glLightfv(GL_LIGHT1, GL_AMBIENT, lt1_ambient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, lt1_diffuse);
}
//------------------------------------------------------------
//@IuWFNg̍ގ
//------------------------------------------------------------
static void setupMaterial(void)
{
	/* IuWFNg̍ގ */
	GLfloat	mat_ambient[]   = {0.0, 0.0, 1.0, 1.0};		// ގ̊
	GLfloat	mat_specular[]  = {0.0, 0.0, 1.0, 1.0};		// ʌ
	GLfloat	mat_shininess[] = {50.0};					// ʌW
	//
	glMaterialfv(GL_FRONT, GL_AMBIENT, mat_ambient);
	glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
	glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
}
//------------------------------------------------------------
//@I
//------------------------------------------------------------
static void cleanup(void)
{
	/* I */
	arVideoCapStop();	// Lv`~
	arVideoClose();		// rfIfoCXI
	argCleanup();		// ARToolkit̏I
}
//------------------------------------------------------------
//@L[Cxg
//------------------------------------------------------------
static void keyEvent( unsigned char key, int x, int y)
{
	/* ESCL[ŏI */
	if( key == 0x1b ) {
		cleanup();
		exit(0);
	}
}
