// -*- C++ -*-
/*!
 * @file  AR_data_out.cpp
 * @brief ARmarker_rec
 * @date $Date$
 *
 * $Id$
 */

#include "AR_data_out.h"

// Module specification
// <rtc-template block="module_spec">
static const char* ar_data_out_spec[] =
  {
    "implementation_id", "AR_data_out",
    "type_name",         "AR_data_out",
    "description",       "ARmarker_rec",
    "version",           "1.0.0",
    "vendor",            "Ogiya Hiroshi",
    "category",          "data_Out",
    "activity_type",     "PERIODIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    "conf.default.dominate", "10",
    // Widget
    "conf.__widget__.dominate", "text",
    // Constraints
    "conf.__constraints__.dominate", "integer_only",
    ""
  };
// </rtc-template>

/*!
 * @brief constructor
 * @param manager Maneger Object
 */
AR_data_out::AR_data_out(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_cameraInIn("cameraIn", m_cameraIn),
    m_positionOutOut("positionOut", m_positionOut),
    m_cameraOutOut("cameraOut", m_cameraOut)

    // </rtc-template>
{
}

/*!
 * @brief destructor
 */
AR_data_out::~AR_data_out()
{
}



RTC::ReturnCode_t AR_data_out::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("cameraIn", m_cameraInIn);
  
  // Set OutPort buffer
  addOutPort("positionOut", m_positionOutOut);
  addOutPort("cameraOut", m_cameraOutOut);
  
  // Set service provider to Ports
  
  // Set service consumers to Ports
  
  // Set CORBA Service Ports
  
  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable
  bindParameter("dominate", m_n, "10");
  // </rtc-template>
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t AR_data_out::onFinalize()
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t AR_data_out::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t AR_data_out::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


RTC::ReturnCode_t AR_data_out::onActivated(RTC::UniqueId ec_id)
{
	m_positionOut.tm.sec = 0;
	m_positionOut.pan  = 0;
	m_positionOut.tilt = 0;

  return RTC::RTC_OK;
}


RTC::ReturnCode_t AR_data_out::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}


RTC::ReturnCode_t AR_data_out::onExecute(RTC::UniqueId ec_id)
{
	if(AR_finder(this))
	{
		return RTC::RTC_ERROR;
	}
	return RTC::RTC_OK;
}


RTC::ReturnCode_t AR_data_out::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}


RTC::ReturnCode_t AR_data_out::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}


RTC::ReturnCode_t AR_data_out::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t AR_data_out::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

/*
RTC::ReturnCode_t AR_data_out::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/



extern "C"
{
 
  void AR_data_outInit(RTC::Manager* manager)
  {
    coil::Properties profile(ar_data_out_spec);
    manager->registerFactory(profile,
                             RTC::Create<AR_data_out>,
                             RTC::Delete<AR_data_out>);
  }
  
};


